(function($){
  function init(root){
    var cfgEl=root.nextElementSibling, cfg={}; try{ cfg=JSON.parse(cfgEl&&cfgEl.classList.contains('h3dg-config')?cfgEl.textContent:'{}'); }catch(e){}
    var mv=root.querySelector('.h3dg-mv'); var h=root.getAttribute('data-height')||'520'; mv.style.height=parseInt(h,10)+'px';
    root.querySelectorAll('.h3dg-tab').forEach(function(tab){
      tab.addEventListener('click', function(){
        root.querySelectorAll('.h3dg-tab').forEach(function(t){t.classList.remove('active'); t.setAttribute('aria-selected','false');});
        tab.classList.add('active'); tab.setAttribute('aria-selected','true');
        var cat=tab.dataset.cat;
        root.querySelectorAll('.h3dg-list').forEach(function(l){ l.style.display=(l.dataset.cat===cat)?'block':'none'; });
        var first=root.querySelector('.h3dg-list[data-cat="'+cat+'"] .h3dg-card'); if(first){ first.click(); }
      });
    });
    root.querySelectorAll('.h3dg-card').forEach(function(card){
      card.addEventListener('click', function(){
        root.querySelectorAll('.h3dg-card').forEach(function(c){ c.classList.remove('active'); });
        card.classList.add('active');
        var src=card.dataset.model||'', poster=card.dataset.poster||''; var env=card.dataset.env||cfg.env||'neutral'; var orbit=card.dataset.camera||cfg.orbit||'0deg 70deg 1.5m';
        if(poster) mv.setAttribute('poster', poster);
        mv.setAttribute('environment-image', env); mv.setAttribute('camera-orbit', orbit);
        if(src) mv.setAttribute('src', src);
        if(mv.dismissPoster) mv.dismissPoster();
      });
    });
    mv.addEventListener('progress', function(e){
      var bar=root.querySelector('.h3dg-progress-inner'), txt=root.querySelector('.h3dg-progress-text');
      if(!bar||!txt||!e.detail||e.detail.total===0) return;
      var pct=Math.min(100,Math.round(100*e.detail.loaded/e.detail.total)); var fill=bar.querySelector('.inner-fill'); if(!fill){ fill=document.createElement('div'); fill.className='inner-fill'; bar.appendChild(fill); }
      fill.style.cssText='height:100%;background:#38c6bd;width:'+pct+'%'; txt.textContent=pct<100?('Loading '+pct+'%'):'Processing…';
    });
    root.querySelector('.btn-reset').addEventListener('click', function(){ mv.cameraOrbit=cfg.orbit||'0deg 70deg 1.5m'; mv.fieldOfView=cfg.fov||'30deg'; if(mv.resetTurntableRotation) mv.resetTurntableRotation(); });
    root.querySelector('.btn-ar').addEventListener('click', function(){ if(mv&&mv.activateAR) mv.activateAR(); });
    root.querySelector('.btn-screenshot').addEventListener('click', async function(){ try{ var b=await mv.toBlob({mimeType:'image/png'}); var a=document.createElement('a'); a.href=URL.createObjectURL(b); a.download='model-view.png'; a.click(); URL.revokeObjectURL(a.href);}catch(e){ alert('Screenshot not supported.'); } });
    // Fullscreen
    var fsBtn=root.querySelector('.btn-fullscreen');
    function inFS(){ return document.fullscreenElement||document.webkitFullscreenElement||document.msFullscreenElement; }
    function reqFS(el){ (el.requestFullscreen||el.webkitRequestFullscreen||el.msRequestFullscreen||el.mozRequestFullScreen).call(el); }
    function exitFS(){ (document.exitFullscreen||document.webkitExitFullscreen||document.msExitFullscreen||document.mozCancelFullScreen).call(document); }
    function update(){ fsBtn.textContent=inFS()?'Exit Fullscreen':'Fullscreen'; }
    fsBtn.addEventListener('click', function(){ if(inFS()) exitFS(); else reqFS(mv); });
    document.addEventListener('fullscreenchange', update); document.addEventListener('webkitfullscreenchange', update); document.addEventListener('msfullscreenchange', update);
  }
  document.addEventListener('DOMContentLoaded', function(){ document.querySelectorAll('[data-h3dg]').forEach(init); });
})(jQuery);
